/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.utils;

import filenet.vw.base.logging.Logger;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.client.Call;
import org.apache.axis.message.SOAPEnvelope;

public class AxisHelper {
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.utils");
    protected static final String m_className = "VWSessionManager";

    public static String _get_FILE_DATE() {
        return "$Date$";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author$";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision$";
    }

    public static SOAPMessage callEx(SOAPConnection connection, SOAPMessage request, String endPoint, int wsTimeout, boolean oneWay) throws Exception {
        String m_method = "callEx:" + endPoint;
        Call call = null;
        try {
            String[] soapActionURIs;
            logger.entering(m_className, m_method);
            call = new Call(endPoint);
            ((Message)request).setMessageContext(call.getMessageContext());
            SOAPEnvelope env = ((Message)request).getSOAPEnvelope();
            Attachments attachments = ((Message)request).getAttachmentsImpl();
            if (attachments != null) {
                for (Object attachment : attachments.getAttachments()) {
                    call.addAttachmentPart(attachment);
                }
            }
            call.setReturnClass(SOAPMessage.class);
            MimeHeaders headers = request.getMimeHeaders();
            if (headers != null && (soapActionURIs = request.getMimeHeaders().getHeader("SOAPAction")) != null) {
                call.setUseSOAPAction(true);
                String soapActionURI = soapActionURIs[0];
                call.setSOAPActionURI(soapActionURI);
            }
            call.setTimeout(new Integer(wsTimeout));
            call.invoke(env);
            Message message = call.getResponseMessage();
            return message;
        }
        catch (MalformedURLException mue) {
            throw new SOAPException((Throwable)mue);
        }
        catch (AxisFault af) {
            if (oneWay && af.getMessage().indexOf("Premature") > -1 && call != null && call.getMessageContext().getResponseMessage() != null) {
                SOAPMessage sOAPMessage = null;
                return sOAPMessage;
            }
            throw new SOAPException((Throwable)af);
        }
        catch (RemoteException re) {
            throw new SOAPException((Throwable)re);
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }
}

